“Hyper Expansion” (`HEXP` in CSS) is an [axis](/glossary/axis_in_variable_fonts) found in some [variable fonts](/glossary/variable_fonts) that can be used to stretch the distance among glyphs by increasing the width of the glyphs themselves and also their connections (in joined writing models) or the spacing (in disconnected writing models).

The [Google Fonts CSS v2 API](https://developers.google.com/fonts/docs/css2) defines the axis as:

| Default: | Min: | Max: | Step: |
| --- | --- | --- | --- |
| 0 | 0 | 100 | 0.1 |

<figure>

![An image showing two type specimens, each with an axis slider underneath. The specimen on the left shows the effects of the axis’ lowest value. The specimen on the right shows the effects of the axis’ highest value.](images/thumbnail.svg)

<figcaption>Typeface: <a href="https://fonts.google.com/specimen/Readex+Pro">Readex Pro</a></figcaption>
</figure>

Although at first glance Hyper Expansion may appear similar to the [Width axis](/glossary/width_axis) (`wdth` in CSS), its chief concern is legibility, and specifically with the Arabic script. For detailed information, please read [“The Design of Readex Pro” on the Material Design blog](https://material.io/blog/readex-pro-legibility-arabic-type-design).