In type design, spacing refers to the act of setting the horizontal space around each [glyph](/glossary/glyph). This is different from kerning, where the type designer adds specific rules (known as [kerning data](/glossary/kerning_kerning_pairs)) to determine the space between two or more specific glyphs. However, the reference to a “well-spaced font” generally means the spacing is both visually consistent and appropriate (i.e., is not too loose or too tight) for the typical size the font is expected to be used at.

<figure>

![The word “axe” with the baseline and x-height shown, and the “x” character highlighted to demonstrate the horizontal spaces inside and outside the glyph.](images/thumbnail.svg)

<figcaption>The blue box illustrates the internal spacing within the “x” glyph; the red boxes illustrate the external spacing. Note how the left and right values are intentionally unequal.</figcaption>

</figure>

When *setting* type, spacing can also refer to the act of making any typographic adjustment that affects space, such as [leading](/glossary/line_height_leading) (the vertical space between two lines of type), [tracking](/glossary/tracking_letter_spacing) (the overall horizontal spacing between glyphs in a block of text), or kerning (the specific horizontal spacing between two or more glyphs).