Throughout his lifetime (1397–1450), King Sejong the Great of Korea was both passionate and vocal about his conviction that every person, regardless of their position in society, should have the opportunity to become literate.

Because he understood the usability limitations of existing [alphabets](/glossary/alphabet), he saw an opportunity to completely re-imagine how a writing system could work. Specifically, in designing Hangeul, he broke from thousands of years of tradition by purposefully creating an alphabet that was easy to learn, easy to read, and easy to write—and he defied the strict societal norms of his day by using his creation to help common citizens become literate.

The story of King Sejong and the creation of the Korean alphabet surely offers some lessons for today’s design challenges, whether our intention is to make a website more readable or to transform the lives of those around us.

## Solving for the people

The first lesson for human-centered design is to be principled and predictable.

What is clear from an examination of Hangeul is that King Sejong had a firm grasp on the principles he wanted to employ for his alphabet, and he consistently incorporated these principles into his designs—for example, using different visual treatments to help differentiate consonant [letters](/glossary/letters) from vowel letters. When learning a new technology, there may be nothing less helpful than arbitrary design; on the other hand, good design affords us the benefit of predictability, and good design is (almost!) always principled.

Another important lesson from Hangeul is to care deeply about Information Architecture.

Objectively, most of King Sejong’s innovations revolve around new or improved ways of providing meaningful information to users. One of the most notable ways he accomplished this, for instance, was in his use of letter shapes that resemble the speech organs used when producing their corresponding sounds. As humans, it’s in our nature to seek meaning from the chaos of information we encounter (which is one reason why we tend to perceive familiar shapes in clouds). As designers, we can help the people who use our designs by being deliberate in how we present the information we have to share.

The third lesson to consider is to embrace your constraints.

Arguably, what allowed King Sejong to produce an alphabet that was so distinguishable from others was that he fully embraced the constraints he faced—for example, aiming to create letters that could be easily read and easily written, rather than just settling on optimizing for one of these experiences. It’s understandable that, when we’re faced with really hard design challenges, we often look for shortcuts or work-arounds, but the common saying, *Necessity is the mother of invention*, bears some truth.

The fourth lesson from Hangeul is to focus on solving the hardest problems.

History tells us that designing alphabets is a hard enough problem to solve that our species has resorted mostly to recycling old solutions. King Sejong could have set out simply to design a new alphabet, but part of his brilliance was in recognizing the hardest problem: How to create an alphabet that could quickly be learned by people who would be learning under the least optimal conditions. The more we empathize with others, the more likely we are to recognize the hardest problems; and the more we focus on solving these problems, the more likely we are to produce designs that improve the human condition.

This point leads us finally to our last lesson, which is to work with empathy.

King Sejong spent years of his life laboring to solve a problem that he personally did not experience. That is, although he was literate, he believed deeply in the importance of bringing literacy to his people, even though such an outcome would threaten the very power structure of which he was at the top. Empathy is central to the philosophy of modern-day UX design, but there’s never a bad time to remind ourselves of just why this is so important.

## From the past to the future

We don’t often think of alphabets as tools that are capable of harming or helping others, but looking back in history at the creation of Hangeul, we can see that this is very much the case.

For those of us that work with the artifacts of language, the story of King Sejong might serve as a reminder that there are always opportunities to bring about positive change through our efforts, even when we’re faced with seemingly insurmountable design challenges.

It is encouraging that today’s type-designers, typographers, and UX practitioners are already leading the charge, making the world’s writing more readable, designing type that supports individual accessibility needs, and, through initiatives like [Noto](https://fonts.google.com/noto?query=open), helping to ensure that the alphabets from an increasing number of endangered languages can be used with modern technology.

Perhaps if he were alive today, King Sejong would be delighted to see so many others carrying on in his spirit.
